<?php
$fileinfo = @getimagesize($imageSN["tmp_name"]);

$allowed = [
    'jpg',
    'png',
    'jpeg'
];

// Get image file extension
$file_extension = pathinfo($imageSN["name"], PATHINFO_EXTENSION);

// Validate file input to check if is not empty
if (! file_exists($imageSN["tmp_name"])) {
    $response = array(
        "type" => "error",
        "message" => "Choose image file to upload."
    );
} else {

    $temp = explode(".", $imageSN["name"]);
    $newFileName = round(microtime(true)) . '.' . end($temp);
    $targetsn = "views/admin/img/sn/" . $newFileName;

    if (move_uploaded_file($imageSN["tmp_name"], $targetsn)) {
        $response = array(
            "type" => "success",
            "message" => "Image uploaded successfully."
        );
    } else {
        $response = array(
            "type" => "error",
            "message" => "Problem in uploading image files."
        );
    }
}
?>