<?php

function view($name, $model = '')
{
    global $viewBag;
    require('views/layout.view.php');
}


function sanitize($value)
{
    $temp = filter_var(trim($value), FILTER_SANITIZE_STRING);

    if ($temp === false) {
        return '';
    }
    return $temp;
}
function getCode($n) {
    $characters = '0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $randomString = '';
    
    for ($i = 0; $i < $n; $i++) {
        $index = rand(0, strlen($characters) - 1);
        $randomString .= $characters[$index];
    }
    return $randomString;
    }
function is_get()
{
    return $_SERVER['REQUEST_METHOD'] === 'GET';
}

function is_post()
{
    return $_SERVER['REQUEST_METHOD'] === 'POST';
}

function redirect($url)
{
    header("Location: $url");
    die();
}


function error_message($error_message)
{
    return isset($error_message) === true;
}


function is_user_authenticated()
{
    return isset($_SESSION['username']);
}


function ensure_user_is_authenticated()
{
    if (!is_user_authenticated()) {
        redirect('../raffle/login.php');
        die();
    }
}