<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Check if user is logged in
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    // Redirect to login page if not logged in
    header("Location: ..login.php");
    exit;
}
?>



<?php include_once("db-connect.php"); ?>
<?php
// MAX draw = 265
$MAX_DRAW = 14;

// Get latest drawn number (highest 'draw' already used)
$draw_qry = $conn->query("SELECT * FROM winners ORDER BY ABS(draw) ASC LIMIT 1");
$tickets_qry = $conn->query("SELECT * FROM tickets");
$ticketsCount = $tickets_qry->fetch_all(MYSQLI_ASSOC);

$draw = $MAX_DRAW; // default first draw = 23

if ($draw_qry->num_rows) {
    $last_draw = $draw_qry->fetch_assoc()['draw'];
    $draw = $last_draw - 1; // go DOWN
}

function ordinal($int = 1){
    $last_digit = substr($int, -1);
    $last_two   = substr($int, -2);

    if(in_array($last_two, ['11','12','13'])) {
        return $int . "th";
    }

    switch($last_digit){
        case 1: return $int."st";
        case 2: return $int."nd";
        case 3: return $int."rd";
        default: return $int."th";
    }
}
function getPrizeCategory($draw){
    if ($draw >= 5 && $draw <= 23) {
        $draw = $draw - 4;
        return "Consolation Prize ($draw) ";
    }
    elseif ($draw >= 2 && $draw <= 4) {
        $draw = $draw - 1;
        return "Major Prize ($draw)";
    }
    elseif ($draw == 1 ) {
        return "Grand Prize ($draw)";
    }
    return "GX Raffle Draw";
}
$draw_text =  " Raffle Draw ";

$prize_category = getPrizeCategory($draw);
// Stop at 1
if ($draw < 1) {
    $draw_text = "Congratulations to all the Winners!";
}
?>
<div class="col-lg-8 col-md-10 col-sm-12 col-xs-12 mx-auto h-100 d-flex flex-column justify-content-center align-items-center">
    <h1 class="prize-banner"><b><?= $prize_category ?></b></h1>
    <div id="raffle-draw" class="w-100">
        <input type="hidden" id="rdraw" value="<?= $draw ?>">
        <input type="hidden" id="draw_text" value="<?= $draw_text ?>">
        <h2 class="text-center text-light" style="text-shadow:2px 2px 5px #000"><b><?= $draw_text ?></b></h2>
        <hr style="position: relative;">
        <?php if (!empty($ticketsCount)) : ?>
            <div class="arrow-draw"></div>
        <?php endif; ?>
        <div id="ticket-list" class="d-flex overflow-hidden">
            <?php
            $highlight = false;
            $where = "";
            if(!isset($_GET['include_winners']))
            $where = " where id not in (SELECT ticket_id FROM winners)";

            $qry = $conn->query("SELECT * FROM tickets {$where} /*order by name asc  LIMIT 5000 */ ");
            if($qry->num_rows > 0):
                while($row = $qry->fetch_assoc()):
            ?>
            <div class="col-auto ticket-item <?= (!$highlight) ? 'highlight-item' : '' ?>" data-id="<?= $row['id'] ?>">
                <div class="card rounded-0 mx-2">
                    <div class="card-body card-draw">
                        <div class="container-fluid item-details">
                            <h3 class="text-muted text-center item-code"><?= $row['code'] ?></h3>
                            <h2 class="text-center item-name"><?= $row['name'] ?></h2>
                        </div>
                    </div>
                </div>
            </div>
            <?php $highlight = true; ?>
            <?php endwhile; ?>
            <?php else: ?>
            <?php endif; ?>
        </div>
        <hr>
        <div class="d-flex w-100 justify-content-between align-items-end">
            <div class="col-auto">
                <div class="text-light">Total Tickets = <b><?= number_format($qry->num_rows) ?></b></div>
            </div>
            <div class="col-auto">
                <div class="form-check form-switch">
                    <input class="form-check-input" type="checkbox" role="switch" id="exclude_winners" <?= (isset($_GET['include_winners'])) ? "" : "checked" ?>>
                    <label class="form-check-label text-muted" for="exclude_winners">Exclude Winners</label>
                </div>
            </div>
        </div>
        <div class="text-center mt-4">
            <button class="btn btn-lg btn-primary rounded-pill col-lg-4 col-md-6 col-sm-8 col-xs-10" type="button" id="draw">Draw</button>
            <?php
            if($draw === 0) {
                    echo "<script>
                        document.getElementById('draw').disabled = true;
                    </script>";
                }
             ?>
        </div>
    </div>
</div>
<?php $conn->close(); ?>

<div class="modal fade rounded-0" id="winnerModal" data-bs-backdrop="static">
    <div class="modal-dialog  modal-lg modal-dialog-centered modal-dialog-scrollable rounded-0">
        <div class="modal-content rounded-0">

            <div class="modal-body rounded-0">
                <div class="container-fluid h-50">
                    <div id="win_template" class="position-relative">
                        <img src="win_bg.jpg" alt="" class="img-fluid" >
                        <div id="winner_greet">
                            <h3 id="draw_winner" class="text-center"><b></b></h3>
                            <h1 class="text-center"><b>Congratulations!!</b></h1>
                        </div>
                        <div id="winner_name">
                            <h3 id="winner_code" class="text-center"><b></b></h3>
                            <h1 id="winner" class="text-center"><b></b></h1>
                        </div>
                    </div>
                </div>
                <div class="text-center my-2">
                    <button type="button" class="btn btm-sm rounded-pill btn-light border" data-bs-dismiss="modal" >Save Winner</button>
                </div>
            </div>
        </div>
    </div>
</div>