<?php

require('dataprovider.class.php');


class Data
{
    static private $ds;
    static public function initialize(DataProvider $data_provider)
    {
        return self::$ds = $data_provider;
    }

    static public function get_records($num_per_page)
    {
        return self::$ds->get_records($num_per_page);
    }

    static public function get_records_prev($num_per_page)
    {
        return self::$ds->get_records_prev($num_per_page);
    }

    static public function add_record_code($date, $promocode, $receiptNo)
    {
        return self::$ds->add_record_code($date, $promocode, $receiptNo);
    }
    static public function add_record_ticket( $promocode, $fullname)
    {
        return self::$ds->add_record_ticket( $promocode, $fullname);
    }
    static public function select_record_registered($receiptNo)
    {
        return self::$ds->select_record_registered($receiptNo);
    }
    static public function get_record_item()
    {
        return self::$ds->get_record_item();
    }

    static public function get_record_login($username, $password)
    {
        return self::$ds->get_record_login($username, $password);
    }
    static public function add_user_to_history($data)
    {
        return self::$ds->add_user_to_history($data);
    }
    static public function get_record_login_date()
    {
        return self::$ds->get_record_login_date();
    }

    static public function get_record_is_online($username)
    {
        return self::$ds->get_record_is_online($username);
    }

    static public function get_record_is_locked($username)
    {
        return self::$ds->get_record_is_locked($username);
    }

    static public function add_user_to_online($username)
    {
        return self::$ds->add_user_to_online($username);
    }

    static public function search_record($search, $whereto)
    {
        return self::$ds->search_record($search, $whereto);
    }

    static public function add_record($fname,
        $minitial,
        $lname,
        $registeredEmail,
        $contactNumber,
        $unitName,
        $dateOfPurch,
        $receiptNumber,
        $receiptAmount,
        $target
        ) {
                return self::$ds->add_record($fname,
            $minitial,
            $lname,
            $registeredEmail,
            $contactNumber,
            $unitName,
            $dateOfPurch,
            $receiptNumber,
            $receiptAmount,
            $target
            );
    }

    static public function update_term($original_term, $new_term, $definition)
    {
        return self::$ds->update_term();
    }

    static public function delete_record($username)
    {
        return self::$ds->delete_record($username);
    }
}
