<?php
$path = '/whitehaus/raffle/';
?>

<header class="nav-header">
    <div class="nav-header_logo">
        <a href="<?= $path ?>"><img src="views/admin/img/assets/icon/whiteHaus_black.png" alt="GX Logo" ></a>
    </div>

    <!-- Hamburger Icon -->
    <div class="hamburger" id="hamburger">
        <span></span>
        <span></span>
        <span></span>
    </div>
</header>

<nav class="navigation__panel" id="navPanel">
    <ul>
        <li><a href="<?= $path ?>">Promo Mechanics</a></li>
        <li><a href="<?= $path ?>participating-models.php">Participating Stores</a></li>
        <li><a href="<?= $path ?>prizes.php">Prizes</a></li>
        <li><a href="<?= $path ?>list-of-winners.php">List of Winners</a></li>
        <li><a href="<?= $path ?>condition.php">Register to E-Raffle</a></li>
    </ul>
    <div class="nav_logo">
        <a href="<?= $path ?>" class="not-active "><img src="views/admin/img/assets/icon/whiteHaus_black.png" alt="GX Logo" ></a>
    </div>
</nav>

<script>
document.addEventListener("DOMContentLoaded", function () {
    const currentPath = window.location.pathname;
    const links = document.querySelectorAll(".navigation__panel a");

    links.forEach(link => {
        const href = link.getAttribute("href");

        // Fix: Only mark index as active when EXACT match
        if (href === "<?= $path ?>" && currentPath === "<?= $path ?>") {
            link.classList.add("active");
        }
        // Other pages: match exact filename
        else if (href !== "<?= $path ?>" && currentPath.endsWith(href.replace("<?= $path ?>", ""))) {
            link.classList.add("active");
        }
    });


  /* MOBILE MENU TOGGLE */
    const hamburger = document.getElementById("hamburger");
    const navPanel = document.getElementById("navPanel");

    hamburger.addEventListener("click", () => {
        navPanel.classList.toggle("open");
    });


});
</script>
